import sys

sys.path.append("../")

import numpy as np
from typing import List
from methods.saddle import CentralizedExtragradient, Logger, ConstraintsL2
from oracles.saddle import BaseSmoothSaddleOracle


class CentralizedExtragradientRunner(object):
    def __init__(
            self,
            oracles: List[BaseSmoothSaddleOracle],
            L: float,
            r_x: float,
            r_y: float,
            logger: Logger
    ):
        self.oracles = oracles
        self.L = L
        self.r_x = r_x
        self.r_y = r_y
        self.logger = logger
        self._params_computed = True

    def create_method(self, z_0):

        self.method = CentralizedExtragradient(
            oracles=self.oracles,
            stepsize=  1. / self.L,
            z_0=z_0,
            logger=self.logger,
            constraints=ConstraintsL2(self.r_x, self.r_y)
        )

    def run(self, max_iter, max_time=None):
        self.method.run(max_iter, max_time)
